package unitTest;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Scanner;

import javax.swing.ImageIcon;

import org.apache.commons.lang3.StringUtils;
import org.junit.Test;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.org.apache.xerces.internal.impl.xpath.regex.ParseException;

import netsdk.callback.SUBSCRIBE_CALLBACK;
import netsdk.callback.impl.SUBSCRIBE_CALLBACK_IMPL;
import netsdk.lib.CommonFunctions;
import netsdk.lib.DeviceSdk;
import netsdk.lib.ErrorCodeAndConst;
import netsdk.struct.*;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;



import java.awt.image.BufferedImage; 
public class Vehicle_Test {
	public static NativeLong loginId;
	public static String targetInfo;
	public static boolean m_SubscribVehicle;//是否订阅车牌识别报警
	public static String m_serverAddressVFD;//
	public static SUBSCRIBE_CALLBACK AlarmCB;
	public static LPNET_SDK_DEVICEINFO.ByReference lpDeviceInfo;
	/**
	 * 初始化，登录
	 * 
	 * @Title: A
	 * @Description: TODO
	 * @return: void
	 */
	//@Test
	public void A() throws Throwable{
		Boolean initResult = CommonFunctions.init();
		if(!initResult)
			return;
		else {
			
			lpDeviceInfo = new LPNET_SDK_DEVICEINFO.ByReference();			
			loginId = CommonFunctions.login(lpDeviceInfo);
			System.out.println("设备id是：" + lpDeviceInfo.deviceID);
			try {
				String name = new String(lpDeviceInfo.deviceName, "GB2312");
				System.out.println("设备名称是：" + name);
			} catch (UnsupportedEncodingException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			System.out.println("设备mac是：" + CommonFunctions.GetDeviceMAC(lpDeviceInfo.deviceMAC));
			;
			
			// 释放内存
			Pointer p = lpDeviceInfo.getPointer();
			long peer = Pointer.nativeValue(p);
			Native.free(peer);// 手动释放内存
			Pointer.nativeValue(p, 0);
			try {
				Thread.sleep(1000L);
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			
		}
	}

	/**
	 * 订阅报警
	 * @Title: SubscribAlarm
	 *
	 * */
	//@Test
	public void SubscribAlarm() {
		if(loginId == null||loginId.intValue() < 1) {
			try {
				A();
			} catch (Throwable e) {
				e.printStackTrace();
			}
		}
		int chn = 0;//IPC通道一般为0
		NET_DVR_SUBSCRIBE_REPLY.ByReference sSmartSubscrib = new NET_DVR_SUBSCRIBE_REPLY.ByReference();
		if(!m_SubscribVehicle) {
			boolean ret = DeviceSdk.INSTANCE.NET_SDK_SmartSubscrib(loginId, ErrorCodeAndConst.NET_IPC_SMART_VIHICLE, chn, sSmartSubscrib);
			if(ret) {
				m_SubscribVehicle = true;
				
				m_serverAddressVFD = new String(sSmartSubscrib.serverAddress);
				System.out.println(m_serverAddressVFD);
			}
		}
		
		
		
								
	}
	/**
	 * 取消订阅报警
	 * @Title: UnSubscribAlarm
	 *
	 * */
	//@Test
	public void UnSubscribAlarm() {	
		if(m_SubscribVehicle) {
			int chn = 0;//IPC通道一般为0
			NET_DVR_SUBSCRIBE_REPLY.ByReference sSmartSubscrib = new NET_DVR_SUBSCRIBE_REPLY.ByReference();
			byte[] sb = m_serverAddressVFD.getBytes();
			Pointer pNativeData = new Memory(sb.length); 
			pNativeData.write(0, sb, 0, sb.length);		
			IntByReference dwResult = new IntByReference();
			boolean ret = DeviceSdk.INSTANCE.NET_SDK_UnSmartSubscrib(loginId, ErrorCodeAndConst.NET_IPC_SMART_VIHICLE, chn, pNativeData, dwResult);
			if(ret) {
				m_SubscribVehicle = false;
				System.out.println("取消订阅报警成功");
			}
			// 释放内存
			long peer = Pointer.nativeValue(pNativeData);
			Native.free(peer);// 手动释放内存
			Pointer.nativeValue(pNativeData, 0);
		}
			
	}
	@Test
	public void setInteligentAlarmCallBack() throws Throwable {

		if(loginId == null||loginId.intValue() < 1) {
			try {
				A();
			} catch (Throwable e) {
				e.printStackTrace();
			}
		}
		if(!m_SubscribVehicle) {
			SubscribAlarm();
		}
		AlarmCB = new SUBSCRIBE_CALLBACK_IMPL();
        // TODO 设置智能分析事件上报回调
        DeviceSdk.INSTANCE.NET_SDK_SetSubscribCallBack(AlarmCB, null);
		 Scanner s = new Scanner(System.in);
	     while (s.hasNext()){
	         if(s.next().equals("q")){
	             break;
	         }
	     }    
	}


    
}
